/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.browser;

import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.Service;
import ibm.nways.jdm.browser.BrowserNode;
import ibm.nways.jdm.browser.BrowserQuery;
import ibm.nways.jdm.browser.BrowserTree;
import ibm.nways.jdm.common.OID;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;

public class BrowserService
extends UnicastRemoteObject
implements Service,
BrowserQuery,
Runnable {
    BrowserTree tree = new BrowserTree();
    private static final int COLON = 58;
    private static final int PERIOD = 46;
    private static final int EOLN = 10;
    private static final int COMMA = 44;
    private static final int QUOTE = 34;
    private BufferedInputStream input;
    private int numrecords;
    private int ix;
    private boolean eofReached;
    private boolean eofRead;
    private byte[] buffer;
    private String inputFile = "bell.all";
    public static final String SERVICE_NAME = "Browser Metadata";
    public static final String THREAD_NAME = "BrowserMetadataLoad";

    public void start() {
        Thread thread = new Thread(this);
        thread.setName(THREAD_NAME);
        thread.setPriority(1);
        thread.start();
    }

    public void run() {
        JdmServerImpl.getSingleton();
        String string = JdmServerImpl.getProperty("baseDir");
        String string2 = "/java/properties/";
        JdmServerImpl.getSingleton();
        String string3 = JdmServerImpl.getProperty("browserInputFile");
        if (string3 != null && !string3.equals("")) {
            char c;
            if (string != null && !string.equals("")) {
                c = string.charAt(string.length() - 1);
                if (c == '/' || c == '\\') {
                    string = string.substring(0, string.length() - 1);
                }
            } else {
                string = "";
            }
            if ((c = string3.charAt(0)) == '/' || c == '\\') {
                string3 = string3.substring(1);
            }
            Registry registry = JdmServerImpl.getRegistry();
            System.out.println("Browser services loading definitions from file: " + string + string2 + string3 + " on separate thread");
            this.loadOIs(String.valueOf(string) + string2 + string3);
            try {
                registry.rebind("BrowserService", this);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
            System.out.println("Browser service registered");
            return;
        }
        System.out.println("Browser service abnormally terminated: no input file");
    }

    public void shutdown() {
        this.tree = null;
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public void loadOIs(String string) {
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int[] nArray = new int[1000];
        byte[] byArray = new byte[1000];
        try {
            this.input = new BufferedInputStream(new FileInputStream(string));
            this.buffer = new byte[1024];
            this.ix = 0;
            int n4 = this.input.read(this.buffer, 0, this.buffer.length);
            if (n4 == -1) {
                this.eofRead = true;
            } else if (n4 < this.buffer.length) {
                this.buffer[n4 - 1] = -1;
                this.eofRead = true;
            }
            while (n != -1) {
                Serializable serializable;
                int n5 = this.getch();
                this.getch();
                int n6 = 0;
                n = this.getch();
                while (n != 58) {
                    nArray[n6] = 0;
                    while (n != 46 && n != 58) {
                        nArray[n6] = 10 * nArray[n6] + (n & 0xF);
                        n = this.getch();
                    }
                    ++n6;
                    if (n != 46) continue;
                    n = this.getch();
                }
                OID oID = new OID(nArray, n6);
                int n7 = 0;
                n = this.getch();
                while (n != 58) {
                    byArray[n7] = (byte)n;
                    ++n7;
                    n = this.getch();
                }
                if (n5 == 49) {
                    serializable = new BrowserNode(0, 0, 0, 0, false, false, oID, byArray, n7, null, 0, null);
                    this.tree.addNode((BrowserNode)serializable);
                } else {
                    int n8;
                    n = this.getch();
                    n2 = n & 0xF;
                    this.getch();
                    n = this.getch();
                    if (n == 116) {
                        bl = true;
                        n8 = 0;
                        while (n8 < 4) {
                            this.getch();
                            ++n8;
                        }
                    } else {
                        bl = false;
                        n8 = 0;
                        while (n8 < 5) {
                            this.getch();
                            ++n8;
                        }
                    }
                    n3 = 0;
                    n = this.getch();
                    while (n != 58) {
                        n3 = 10 * n3 + (n & 0xF);
                        n = this.getch();
                    }
                    int n9 = 0;
                    n = this.getch();
                    while (n != 58) {
                        n9 = 10 * n9 + (n & 0xF);
                        n = this.getch();
                    }
                    n6 = 0;
                    serializable = null;
                    n = this.getch();
                    while (n != 58) {
                        nArray[n6] = 0;
                        while (n != 46 && n != 44 && n != 58) {
                            nArray[n6] = 10 * nArray[n6] + (n & 0xF);
                            n = this.getch();
                        }
                        ++n6;
                        if (n == 46) {
                            n = this.getch();
                            continue;
                        }
                        OID oID2 = new OID(nArray, n6);
                        if (serializable == null) {
                            serializable = new Vector(5);
                        }
                        ((Vector)serializable).addElement(oID2);
                        n6 = 0;
                        if (n != 44) continue;
                        n = this.getch();
                    }
                    int n10 = 0;
                    byte[] byArray2 = null;
                    n = this.getch();
                    while (n != 58) {
                        n10 = n10 * 10 + (n & 0xF);
                        n = this.getch();
                    }
                    byArray2 = new byte[n10];
                    int n11 = 0;
                    while (n11 < n10) {
                        byArray2[n11] = (byte)this.getch();
                        ++n11;
                    }
                    n = this.getch();
                    BrowserNode browserNode = new BrowserNode(nArray[0], n2, n3, n9, bl, true, oID, byArray, n7, byArray2, n10, (Vector)serializable);
                    this.tree.addNode(browserNode);
                    ++this.numrecords;
                }
                n = this.getch();
            }
            long l2 = System.currentTimeMillis() - l;
            System.err.println("Browser data load on separate thread complete, " + this.numrecords + " records in " + l2 + " msec");
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Browser services initialization error: " + fileNotFoundException);
            System.out.println("Browser services initialized with no metadata!");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private int getch() {
        int n = -1;
        if (this.ix < this.buffer.length) {
            n = this.buffer[this.ix];
            ++this.ix;
        } else if (!this.eofRead) {
            int n2 = -1;
            try {
                n2 = this.input.read(this.buffer, 0, this.buffer.length);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.ix = 0;
            if (n2 == this.buffer.length) {
                n = this.buffer[this.ix];
                ++this.ix;
            } else if (n2 < this.buffer.length) {
                this.eofRead = true;
                this.buffer[n2 - 1] = -1;
                n = this.buffer[this.ix];
                ++this.ix;
            } else {
                this.eofRead = true;
                this.eofReached = true;
            }
        }
        if (n == 13) {
            n = this.getch();
        }
        return n;
    }

    public void DisplayNode(BrowserNode browserNode) {
        this.DisplayNode(browserNode, 0);
    }

    public void DisplayNode(BrowserNode browserNode, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        if (browserNode.item) {
            System.out.println(String.valueOf(stringBuffer) + "node:" + browserNode.getName() + "(" + browserNode.oid.toString() + ")*");
        } else {
            System.out.println(String.valueOf(stringBuffer) + "node:" + browserNode.getName() + "(" + browserNode.oid.toString() + ")");
        }
        if (browserNode.children != null) {
            Enumeration enumeration = browserNode.children.elements();
            while (enumeration.hasMoreElements()) {
                OID oID = (OID)enumeration.nextElement();
                this.DisplayNode(this.tree.getNode(oID), n + 3);
            }
        }
    }

    public BrowserNode getNode(String string) throws RemoteException {
        return this.tree.getNode(new OID(string));
    }
}

